/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.layout.components.ComponentWithBounds;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;

@Environment(value=EnvType.CLIENT)
public abstract class LayoutComponent<R extends ComponentRenderer, L extends LayoutComponent<R, L>>
implements ComponentWithBounds,
GuiEventListener {
    protected final R renderer;
    protected final Value width;
    protected final Value height;
    protected String debugName;
    protected Rectangle relativeBounds;
    protected Rectangle screenBounds;
    protected Alignment vAlign = Alignment.MIN;
    protected Alignment hAlign = Alignment.MIN;

    public LayoutComponent(Value width, Value height, R renderer) {
        this.width = width.attachComponent(this::getContentWidth);
        this.height = height.attachComponent(this::getContentHeight);
        this.renderer = renderer;
    }

    public void reCalculateLayout() {
        this.updateContainerWidth(this.relativeBounds.width);
        this.updateContainerHeight(this.relativeBounds.height);
        this.setRelativeBounds(this.relativeBounds.left, this.relativeBounds.top);
        this.updateScreenBounds(this.screenBounds.left, this.screenBounds.top);
    }

    protected int updateContainerWidth(int containerWidth) {
        return this.width.setCalculatedSize(containerWidth);
    }

    protected int updateContainerHeight(int containerHeight) {
        return this.height.setCalculatedSize(containerHeight);
    }

    void setRelativeBounds(int left, int top) {
        this.relativeBounds = new Rectangle(left, top, this.width.calculatedSize(), this.height.calculatedSize());
        this.onBoundsChanged();
    }

    public void updateScreenBounds(int worldX, int worldY) {
        this.screenBounds = this.relativeBounds.movedBy(worldX, worldY);
    }

    protected void onBoundsChanged() {
    }

    @Override
    public Rectangle getRelativeBounds() {
        return this.relativeBounds;
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    public abstract int getContentWidth();

    public abstract int getContentHeight();

    public int fillWidth(int parentSize, int fillSize) {
        return this.width.fill(fillSize);
    }

    public int fillHeight(int parentSize, int fillSize) {
        return this.height.fill(fillSize);
    }

    public int getWidth() {
        return this.width.calculatedSize();
    }

    public int getHeight() {
        return this.height.calculatedSize();
    }

    protected final void setClippingRect(Rectangle clippingRect) {
        if (clippingRect == null) {
            RenderSystem.disableScissor();
            return;
        }
        double uiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        RenderSystem.enableScissor((int)((int)((double)clippingRect.left * uiScale)), (int)((int)((double)windowHeight - (double)clippingRect.bottom() * uiScale)), (int)((int)((double)clippingRect.width * uiScale)), (int)((int)((double)clippingRect.height * uiScale)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle parentBounds, Rectangle clipRect) {
        Rectangle r = this.relativeBounds.movedBy(parentBounds.left, parentBounds.top);
        Rectangle clip = r.intersect(clipRect);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.relativeBounds.left, (float)this.relativeBounds.top, 0.0f);
        this.renderInBounds(guiGraphics, mouseX - this.relativeBounds.left, mouseY - this.relativeBounds.top, deltaTicks, r, clip);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle renderBounds, Rectangle clipRect) {
        if (this.renderer != null) {
            this.setClippingRect(clipRect);
            this.renderer.renderInBounds(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
            this.setClippingRect(null);
        }
    }

    public String toString() {
        return super.toString() + "(" + (String)(this.debugName == null ? "" : this.debugName + " - ") + this.relativeBounds + ", " + this.width.calculatedSize() + "x" + this.height.calculatedSize() + ")";
    }

    public L alignTop() {
        this.vAlign = Alignment.MIN;
        return (L)this;
    }

    public L alignBottom() {
        this.vAlign = Alignment.MAX;
        return (L)this;
    }

    public L centerVertical() {
        this.vAlign = Alignment.CENTER;
        return (L)this;
    }

    public L alignLeft() {
        this.hAlign = Alignment.MIN;
        return (L)this;
    }

    public L alignRight() {
        this.hAlign = Alignment.MAX;
        return (L)this;
    }

    public L centerHorizontal() {
        this.hAlign = Alignment.CENTER;
        return (L)this;
    }

    public L setDebugName(String d) {
        this.debugName = d;
        return (L)this;
    }

    public boolean m_5953_(double d, double e) {
        return this.relativeBounds.contains(d, e);
    }
}

